/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_iprobe.c,v 1.34 2006/08/30 04:34:02 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"
#  include "mx__partner.h"
#include "mx__endpoint.h"
#include "mx__request.h"
#include "mx__error.h"

int mx__iprobe_common(mx_endpoint_t ep, uint64_t match_info,
		      uint64_t match_mask, mx_status_t *status);

MX_FUNC(mx_return_t)
mx_iprobe(mx_endpoint_t ep, uint64_t match_info, uint64_t match_mask,
	  mx_status_t *status, uint32_t *result)
{
  /* TODO: Validate endpoint. */

  if (match_info & ~match_mask) {
    return mx__error(ep, "mx_iprobe", MX_BAD_MATCH_MASK);
  }

  /* check that there's no wildcard in the context id range */
  if (!CHECK_MATCHING_WITH_CTXID(ep, match_mask)) {
    return mx__error(ep, "mx_iprobe", MX_BAD_MATCHING_FOR_CONTEXT_ID_MASK);
  }

  MX__MUTEX_LOCK(&ep->lock);
  MX__EP_STATS_INC(ep, test);
  mx__luigi(ep);
  *result = mx__iprobe_common(ep, match_info, match_mask, status);
  if (!*result)
    MX__EP_STATS_INC(ep, noncompleted_test);
  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;
}

int
mx__iprobe_common(mx_endpoint_t ep, uint64_t match_info, uint64_t match_mask,
		  mx_status_t *status)
{
  union mx_request *r;

  if (MX_DEBUG_CSUM && mx__opt.csum) {
    match_mask &= UINT64_C(0x0000ffffffffffff);
  }
  r = mx__endpoint_match_unexpected(ep, match_info, match_mask);
  if (r == NULL) {
    return 0;
  }
  else {
    mx_memcpy(status, &r->recv.basic.status, sizeof (*status));
    if (MX_DEBUG_CSUM && mx__opt.csum) {
      status->match_info &= UINT64_C(0x0000ffffffffffff);
    }
    return 1;
  }
}

#ifdef MX_VERSIONED_SYMS
void mx__conv_status_to_v1(mx_status_t *p);

mx_return_t mx_iprobe_v1(mx_endpoint_t ep, uint64_t match_info, uint64_t match_mask,
	  mx_status_t *s, uint32_t *res)
{
  mx_return_t rc;
  rc = mx_iprobe(ep,match_info, match_mask,s,res);
  mx__conv_status_to_v1(s);
  return rc;
}

__asm__(".symver mx_iprobe_v1,mx_iprobe@MX_0.0");

#endif
